﻿// Question types
var DRILLDOWN = "DrillDown";
var SLIDER = "Slider";
var IMAGE_SELECTOR = "ImageSelector";
var DATE_TIME_ANSWER = "DateTimeAnswer";
var NUMERIC_ANSWER = "NumericAnswer";
var DRAG_DROP_RANKING = "DragDropRanking";
var CARD_SORT = "CardSort";
var IMAGE_AREA_EVALUATOR = "ImageAreaEvaluator";
var IMAGE_AREA_SELECTOR = "ImageAreaSelector";
var HYBRID_GRID = "HybridGrid";
var CHOICE_GRID = "ChoiceGrid";
var RUNNING_TOTAL = "RunningTotal";
var IMAGE_CHOICE_GRID = "ImageChoiceGrid";
var STAR_RATING_GRID = "StarRatingGrid";
var NET_PROMOTER_GRID = "NetPromoter";
var NUMERIC_RANKING = "NumericRanking";

///
/// Additional string function
///
String.prototype.reverse = function () {
    return this.split("").reverse().join("");
};



function getParentFrame() {
    var frame = null;
    var domain = window.location.host;

    for (var i = 0; frame == null && i < top.frames.length; i++) {
        try
        {
            var valid = (top.frames[i] && top.frames[i].location && top.frames[i].location.src == window.location.src);
            frame = top.frames[i];
        }
        catch (e) { }           
    }

    return frame;
}


function IsScrolledIntoView(elem) {
    var docViewTop = $(window).scrollTop();
    var docViewBottom = docViewTop + $(window).height();

    var elemTop = $(elem).offset().top;
    var elemBottom = elemTop + $(elem).height();

    return ((elemBottom >= docViewTop) && (elemBottom <= docViewBottom))
        || ((elemTop <= docViewBottom) && (elemTop >= docViewTop));
}


function GetElementOffset(_element) {
    var _offset = $(_element).offset();

    // FF: Looks like it has been fixed in jQuery 1.5.1
    //
    // When in an iframe, the value returned by the offset is not relative to the iframe
    //    if ($(_element).get(0).ownerDocument !== document) {
    //        _offset.top -= $(document).scrollTop();
    //        _offset.left -= $(document).scrollLeft();
    //    }

    return _offset;
}

RegExp.escape = function (text) {
    if (!arguments.callee.sRE) {
        var specials = [
      '/', '.', '*', '+', '?', '|',
      '(', ')', '[', ']', '{', '}', '\\'
    ];
        arguments.callee.sRE = new RegExp(
      '(\\' + specials.join('|\\') + ')', 'g'
    );
    }
    return text.replace(arguments.callee.sRE, '\\$1');
}

function GetUrlParameters(givenUrl) {
    var url = (givenUrl) ? givenUrl : window.location.href;
    var map = {};

    var parts = url.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
        map[key] = value;
    });

    return map;
}

function GetQuestionNameControl(element) {
    return $(element).parents('.v-questionEdit,.editContent').find('.v-questionName,.createQuestionName').get(0);
}

function GetQuestionName(element) {
    return ($(GetQuestionNameControl(element)).val() || '');
}

function DisableEnter(_e) {
    return (_e.keyCode != 13);
}

function RemoveHtml(value) {
    return value.replace(/(<.*?>)/ig, "");
}

function DisableInvalidCharacters(_e) {
    var _key = _e.which;

    return (
            (_key > 47 && _key < 58) || // 0 - 9
            (_key > 64 && _key < 91) || // A - Z
            (_key > 96 && _key < 129) || // a - z
                _key == 95 || // _
                _key == 45 || // -
                _key == 46 || // .
                _key == 8 || //Backspace
                _key == 0);
}

function RemoveInvalidCharacters(value) {
    return value.replace(/[^a-zA-Z0-9-_.]/g, '');
}

function FixPostForInput(_selector) {
    $(_selector).find(':input[type=text]:not(.enableEnter)').off('keypress.fixpost')
                                          .on('keypress.fixpost', function (_e) { return DisableEnter(_e); });
}

function PostToIFrame(_iframe, _url, _params, _method) {
    _method = _method || "post"; // Set method to post by default, if not specified.
    var _document = _iframe[0].contentWindow.document;

    var form = _document.createElement("form");
    form.setAttribute("method", _method);
    form.setAttribute("action", _url);

    for (var key in _params) {
        if (typeof _params[key] != "function") {
            var hiddenField = _document.createElement("input");
            hiddenField.setAttribute("type", "hidden");
            hiddenField.setAttribute("name", key);
            hiddenField.setAttribute("value", _params[key]);

            form.appendChild(hiddenField);
        }
    }

    _document.body.appendChild(form); // Not entirely sure if this is necessary
    a4.appendAntiForgeryToken(form);
    form.submit();
}

///
/// Cleans HTML so that it becomes valid. 
/// Code taken from nicEdit.
///
function cleanHtml(html) {
    var newSnippet = "";

    function validTags(snippet) {
        var theString = snippet;

        /* Replace uppercase element names with lowercase */
        theString = theString.replace(/<[^> ]*/g, function(match){return match.toLowerCase();});

        /* Replace uppercase attribute names with lowercase */
        theString = theString.replace(/<[^>]*>/g, function(match) {
            match = match.replace(/ [^=]+=/g, function(match2){return match2.toLowerCase();});
            return match;
        });

        /* Put quotes around unquoted attributes */
        theString = theString.replace(/<[^>]*>/g, function(match) {
            match = match.replace(/( [^=]+=)([^"][^ >]*)/g, "$1\"$2\"");
            return match;
        });

        return theString;
    };


    newSnippet = html;
    newSnippet = validTags(newSnippet);

    /* Replace opening bold tags with strong */
    newSnippet = newSnippet.replace(/<b(\s+|>)/g, "<strong$1");
    /* Replace closing bold tags with closing strong */
    newSnippet = newSnippet.replace(/<\/b(\s+|>)/g, "</strong$1");

    /* Replace italic tags with em */
    newSnippet = newSnippet.replace(/<i(\s+|>)/g, "<em$1");
    /* Replace closing italic tags with closing em */
    newSnippet = newSnippet.replace(/<\/i(\s+|>)/g, "</em$1");

    /* strip out comments -cgCraft */
    newSnippet = newSnippet.replace(/<!(?:--[\s\S]*?--\s*)?>\s*/g, "");

    /* strip out &nbsp; -cgCraft */
    newSnippet = newSnippet.replace(/&nbsp;/gi, " ");
    /* strip out extra spaces -cgCraft */
    newSnippet = newSnippet.replace(/ <\//gi, "</");

    while (newSnippet.indexOf("  ") != -1) {
        var anArray = newSnippet.split("  ")
        newSnippet = anArray.join(" ")
    }

    /* strip &nbsp; -cgCraft */
    newSnippet = newSnippet.replace(/^\s*|\s*$/g, "");

    /* Strip out unaccepted attributes */

    newSnippet = newSnippet.replace(/<[^>]*>/g, function (match) {
        match = match.replace(/ ([^=]+)="[^"]*"/g, function (match2, attributeName) {
            if (attributeName == "alt" || attributeName == "href" || attributeName == "src" || attributeName == "title") {
                return match2;
            }

            return "";
        });

        return match;
    }
            );

    /* Final cleanout for MS Word cruft */
    newSnippet = newSnippet.replace(/<\?xml[^>]*>/g, "");
    newSnippet = newSnippet.replace(/<[^ >]+:[^>]*>/g, "");
    newSnippet = newSnippet.replace(/<\/[^ >]+:[^>]*>/g, "");

    /* remove undwanted tags - FF. Do not believe this is necessary */
    //newSnippet = newSnippet.replace(/<(div|span|style|meta|link){1}.*?>/gi, '');

    // Use a div element to hold the HTML and validate it
    newSnippet = $('<div>').html(newSnippet).html();

    return newSnippet;
};

function htmlEncode(value) {
    return $('<div/>').text(value).html();
}

function htmlDecode(value) {
    return $('<div/>').html(value).text();
}

//IE Support - for array index of
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (obj, start) {
        for (var i = (start || 0); i < this.length; i++) {
            if (this[i] == obj) {
                return i;
            }
        }
        return -1;
    }
}

function getObjectCount(object) {
    var count = 0;
    for (var k in object) {
        if (object.hasOwnProperty(k)) {
            ++count;
        }
    }

    return count;
}

//THIS SHOULD BE REMOVED WHEN ImportSampleEditor IS UPDATED. WE SHOULD BE USING AUTONUMERIC FOR HANDLE NUMERIC INPUTS
function validateInt32Bounds(value, minValue, maxValue, positive) {
    if (isNaN(parseInt(minValue, 10))) {
        minValue = -2147483648;
    }

    if (isNaN(parseInt(maxValue, 10))) {
        maxValue = 2147483647;
    }

    if (positive && value < 0) {
        return 0;
    }
    else if (value > maxValue) {
        return Math.min(maxValue, 999999999);
    }
    else if (value < minValue) {
        return Math.max(minValue, -999999999);
    }
    else {
        return value;
    }
}

//THIS SHOULD BE REMOVED WHEN ImportSampleEditor IS UPDATED. WE SHOULD BE USING AUTONUMERIC FOR HANDLE NUMERIC INPUTS
function validateInt64Bounds(value, minValue, maxValue, positive) {
    if (isNaN(parseInt(minValue, 10))) {
        minValue = -9223372036854775808;
    }

    if (isNaN(parseInt(maxValue, 10))) {
        maxValue = 9223372036854775807;
    }

    if (positive && value < 0) {
        return 0;
    }
    else if (value > maxValue) {
        return Math.min(maxValue, 999999999999999999);
    }
    else if (value < minValue) {
        return Math.max(minValue, -999999999999999999);
    }
    else {
        return value;
    }
}



(function ($) {
    var draggableExtensions = {
        refreshContainment: function (event) {

            /// PATCH START ///
            var o = this.options;
            //Set a containment if given in the options
            if (o.containment)
                this._setContainment();
            //Recache the helper size
            this._cacheHelperProportions();
            /// PATCH END ///
        }
    };
    $.extend($.ui.draggable.prototype, draggableExtensions);
})(jQuery);